# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.add_dependencies_task_request import AddDependenciesTaskRequest
from ..model.add_dependencies_task_response import AddDependenciesTaskResponse
from ..model.add_members_task_request import AddMembersTaskRequest
from ..model.add_members_task_response import AddMembersTaskResponse
from ..model.add_reminders_task_request import AddRemindersTaskRequest
from ..model.add_reminders_task_response import AddRemindersTaskResponse
from ..model.add_tasklist_task_request import AddTasklistTaskRequest
from ..model.add_tasklist_task_response import AddTasklistTaskResponse
from ..model.create_task_request import CreateTaskRequest
from ..model.create_task_response import CreateTaskResponse
from ..model.delete_task_request import DeleteTaskRequest
from ..model.delete_task_response import DeleteTaskResponse
from ..model.get_task_request import GetTaskRequest
from ..model.get_task_response import GetTaskResponse
from ..model.list_task_request import ListTaskRequest
from ..model.list_task_response import ListTaskResponse
from ..model.patch_task_request import PatchTaskRequest
from ..model.patch_task_response import PatchTaskResponse
from ..model.remove_dependencies_task_request import RemoveDependenciesTaskRequest
from ..model.remove_dependencies_task_response import RemoveDependenciesTaskResponse
from ..model.remove_members_task_request import RemoveMembersTaskRequest
from ..model.remove_members_task_response import RemoveMembersTaskResponse
from ..model.remove_reminders_task_request import RemoveRemindersTaskRequest
from ..model.remove_reminders_task_response import RemoveRemindersTaskResponse
from ..model.remove_tasklist_task_request import RemoveTasklistTaskRequest
from ..model.remove_tasklist_task_response import RemoveTasklistTaskResponse
from ..model.tasklists_task_request import TasklistsTaskRequest
from ..model.tasklists_task_response import TasklistsTaskResponse


class Task(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def add_dependencies(self, request: AddDependenciesTaskRequest,
                         option: Optional[RequestOption] = None) -> AddDependenciesTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: AddDependenciesTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), AddDependenciesTaskResponse)
        response.raw = resp

        return response

    async def aadd_dependencies(self, request: AddDependenciesTaskRequest,
                                option: Optional[RequestOption] = None) -> AddDependenciesTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: AddDependenciesTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), AddDependenciesTaskResponse)
        response.raw = resp

        return response

    def add_members(self, request: AddMembersTaskRequest,
                    option: Optional[RequestOption] = None) -> AddMembersTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: AddMembersTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), AddMembersTaskResponse)
        response.raw = resp

        return response

    async def aadd_members(self, request: AddMembersTaskRequest,
                           option: Optional[RequestOption] = None) -> AddMembersTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: AddMembersTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), AddMembersTaskResponse)
        response.raw = resp

        return response

    def add_reminders(self, request: AddRemindersTaskRequest,
                      option: Optional[RequestOption] = None) -> AddRemindersTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: AddRemindersTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), AddRemindersTaskResponse)
        response.raw = resp

        return response

    async def aadd_reminders(self, request: AddRemindersTaskRequest,
                             option: Optional[RequestOption] = None) -> AddRemindersTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: AddRemindersTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), AddRemindersTaskResponse)
        response.raw = resp

        return response

    def add_tasklist(self, request: AddTasklistTaskRequest,
                     option: Optional[RequestOption] = None) -> AddTasklistTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: AddTasklistTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), AddTasklistTaskResponse)
        response.raw = resp

        return response

    async def aadd_tasklist(self, request: AddTasklistTaskRequest,
                            option: Optional[RequestOption] = None) -> AddTasklistTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: AddTasklistTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), AddTasklistTaskResponse)
        response.raw = resp

        return response

    def create(self, request: CreateTaskRequest, option: Optional[RequestOption] = None) -> CreateTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateTaskResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateTaskRequest, option: Optional[RequestOption] = None) -> CreateTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateTaskResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteTaskRequest, option: Optional[RequestOption] = None) -> DeleteTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteTaskResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteTaskRequest, option: Optional[RequestOption] = None) -> DeleteTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteTaskResponse)
        response.raw = resp

        return response

    def get(self, request: GetTaskRequest, option: Optional[RequestOption] = None) -> GetTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), GetTaskResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetTaskRequest, option: Optional[RequestOption] = None) -> GetTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), GetTaskResponse)
        response.raw = resp

        return response

    def list(self, request: ListTaskRequest, option: Optional[RequestOption] = None) -> ListTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTaskResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListTaskRequest, option: Optional[RequestOption] = None) -> ListTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTaskResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchTaskRequest, option: Optional[RequestOption] = None) -> PatchTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchTaskResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchTaskRequest, option: Optional[RequestOption] = None) -> PatchTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchTaskResponse)
        response.raw = resp

        return response

    def remove_dependencies(self, request: RemoveDependenciesTaskRequest,
                            option: Optional[RequestOption] = None) -> RemoveDependenciesTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: RemoveDependenciesTaskResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  RemoveDependenciesTaskResponse)
        response.raw = resp

        return response

    async def aremove_dependencies(self, request: RemoveDependenciesTaskRequest,
                                   option: Optional[RequestOption] = None) -> RemoveDependenciesTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: RemoveDependenciesTaskResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  RemoveDependenciesTaskResponse)
        response.raw = resp

        return response

    def remove_members(self, request: RemoveMembersTaskRequest,
                       option: Optional[RequestOption] = None) -> RemoveMembersTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: RemoveMembersTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), RemoveMembersTaskResponse)
        response.raw = resp

        return response

    async def aremove_members(self, request: RemoveMembersTaskRequest,
                              option: Optional[RequestOption] = None) -> RemoveMembersTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: RemoveMembersTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), RemoveMembersTaskResponse)
        response.raw = resp

        return response

    def remove_reminders(self, request: RemoveRemindersTaskRequest,
                         option: Optional[RequestOption] = None) -> RemoveRemindersTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: RemoveRemindersTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), RemoveRemindersTaskResponse)
        response.raw = resp

        return response

    async def aremove_reminders(self, request: RemoveRemindersTaskRequest,
                                option: Optional[RequestOption] = None) -> RemoveRemindersTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: RemoveRemindersTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), RemoveRemindersTaskResponse)
        response.raw = resp

        return response

    def remove_tasklist(self, request: RemoveTasklistTaskRequest,
                        option: Optional[RequestOption] = None) -> RemoveTasklistTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: RemoveTasklistTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), RemoveTasklistTaskResponse)
        response.raw = resp

        return response

    async def aremove_tasklist(self, request: RemoveTasklistTaskRequest,
                               option: Optional[RequestOption] = None) -> RemoveTasklistTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: RemoveTasklistTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), RemoveTasklistTaskResponse)
        response.raw = resp

        return response

    def tasklists(self, request: TasklistsTaskRequest, option: Optional[RequestOption] = None) -> TasklistsTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: TasklistsTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), TasklistsTaskResponse)
        response.raw = resp

        return response

    async def atasklists(self, request: TasklistsTaskRequest,
                         option: Optional[RequestOption] = None) -> TasklistsTaskResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: TasklistsTaskResponse = JSON.unmarshal(str(resp.content, UTF_8), TasklistsTaskResponse)
        response.raw = resp

        return response
