# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.add_members_tasklist_request import AddMembersTasklistRequest
from ..model.add_members_tasklist_response import AddMembersTasklistResponse
from ..model.create_tasklist_request import CreateTasklistRequest
from ..model.create_tasklist_response import CreateTasklistResponse
from ..model.delete_tasklist_request import DeleteTasklistRequest
from ..model.delete_tasklist_response import DeleteTasklistResponse
from ..model.get_tasklist_request import GetTasklistRequest
from ..model.get_tasklist_response import GetTasklistResponse
from ..model.list_tasklist_request import ListTasklistRequest
from ..model.list_tasklist_response import ListTasklistResponse
from ..model.patch_tasklist_request import PatchTasklistRequest
from ..model.patch_tasklist_response import PatchTasklistResponse
from ..model.remove_members_tasklist_request import RemoveMembersTasklistRequest
from ..model.remove_members_tasklist_response import RemoveMembersTasklistResponse
from ..model.tasks_tasklist_request import TasksTasklistRequest
from ..model.tasks_tasklist_response import TasksTasklistResponse


class Tasklist(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def add_members(self, request: AddMembersTasklistRequest,
                    option: Optional[RequestOption] = None) -> AddMembersTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: AddMembersTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), AddMembersTasklistResponse)
        response.raw = resp

        return response

    async def aadd_members(self, request: AddMembersTasklistRequest,
                           option: Optional[RequestOption] = None) -> AddMembersTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: AddMembersTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), AddMembersTasklistResponse)
        response.raw = resp

        return response

    def create(self, request: CreateTasklistRequest, option: Optional[RequestOption] = None) -> CreateTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateTasklistResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateTasklistRequest,
                      option: Optional[RequestOption] = None) -> CreateTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateTasklistResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteTasklistRequest, option: Optional[RequestOption] = None) -> DeleteTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteTasklistResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteTasklistRequest,
                      option: Optional[RequestOption] = None) -> DeleteTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteTasklistResponse)
        response.raw = resp

        return response

    def get(self, request: GetTasklistRequest, option: Optional[RequestOption] = None) -> GetTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), GetTasklistResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetTasklistRequest, option: Optional[RequestOption] = None) -> GetTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), GetTasklistResponse)
        response.raw = resp

        return response

    def list(self, request: ListTasklistRequest, option: Optional[RequestOption] = None) -> ListTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTasklistResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListTasklistRequest, option: Optional[RequestOption] = None) -> ListTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTasklistResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchTasklistRequest, option: Optional[RequestOption] = None) -> PatchTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchTasklistResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchTasklistRequest,
                     option: Optional[RequestOption] = None) -> PatchTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchTasklistResponse)
        response.raw = resp

        return response

    def remove_members(self, request: RemoveMembersTasklistRequest,
                       option: Optional[RequestOption] = None) -> RemoveMembersTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: RemoveMembersTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 RemoveMembersTasklistResponse)
        response.raw = resp

        return response

    async def aremove_members(self, request: RemoveMembersTasklistRequest,
                              option: Optional[RequestOption] = None) -> RemoveMembersTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: RemoveMembersTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 RemoveMembersTasklistResponse)
        response.raw = resp

        return response

    def tasks(self, request: TasksTasklistRequest, option: Optional[RequestOption] = None) -> TasksTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: TasksTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), TasksTasklistResponse)
        response.raw = resp

        return response

    async def atasks(self, request: TasksTasklistRequest,
                     option: Optional[RequestOption] = None) -> TasksTasklistResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: TasksTasklistResponse = JSON.unmarshal(str(resp.content, UTF_8), TasksTasklistResponse)
        response.raw = resp

        return response
