# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .product_i18n_name import ProductI18nName


class TenantAssignInfo(object):
    _types = {
        "subscription_id": int,
        "license_plan_key": str,
        "product_name": str,
        "i18n_name": ProductI18nName,
        "total_seats": int,
        "assigned_seats": int,
        "start_time": int,
        "end_time": int,
    }

    def __init__(self, d=None):
        self.subscription_id: Optional[int] = None
        self.license_plan_key: Optional[str] = None
        self.product_name: Optional[str] = None
        self.i18n_name: Optional[ProductI18nName] = None
        self.total_seats: Optional[int] = None
        self.assigned_seats: Optional[int] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TenantAssignInfoBuilder":
        return TenantAssignInfoBuilder()


class TenantAssignInfoBuilder(object):
    def __init__(self) -> None:
        self._tenant_assign_info = TenantAssignInfo()

    def subscription_id(self, subscription_id: int) -> "TenantAssignInfoBuilder":
        self._tenant_assign_info.subscription_id = subscription_id
        return self

    def license_plan_key(self, license_plan_key: str) -> "TenantAssignInfoBuilder":
        self._tenant_assign_info.license_plan_key = license_plan_key
        return self

    def product_name(self, product_name: str) -> "TenantAssignInfoBuilder":
        self._tenant_assign_info.product_name = product_name
        return self

    def i18n_name(self, i18n_name: ProductI18nName) -> "TenantAssignInfoBuilder":
        self._tenant_assign_info.i18n_name = i18n_name
        return self

    def total_seats(self, total_seats: int) -> "TenantAssignInfoBuilder":
        self._tenant_assign_info.total_seats = total_seats
        return self

    def assigned_seats(self, assigned_seats: int) -> "TenantAssignInfoBuilder":
        self._tenant_assign_info.assigned_seats = assigned_seats
        return self

    def start_time(self, start_time: int) -> "TenantAssignInfoBuilder":
        self._tenant_assign_info.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "TenantAssignInfoBuilder":
        self._tenant_assign_info.end_time = end_time
        return self

    def build(self) -> "TenantAssignInfo":
        return self._tenant_assign_info
