# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .detect_text_request_body import DetectTextRequestBody


class DetectTextRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[DetectTextRequestBody] = None

    @staticmethod
    def builder() -> "DetectTextRequestBuilder":
        return DetectTextRequestBuilder()


class DetectTextRequestBuilder(object):

    def __init__(self) -> None:
        detect_text_request = DetectTextRequest()
        detect_text_request.http_method = HttpMethod.POST
        detect_text_request.uri = "/open-apis/translation/v1/text/detect"
        detect_text_request.token_types = {AccessTokenType.TENANT}
        self._detect_text_request: DetectTextRequest = detect_text_request

    def request_body(self, request_body: DetectTextRequestBody) -> "DetectTextRequestBuilder":
        self._detect_text_request.request_body = request_body
        self._detect_text_request.body = request_body
        return self

    def build(self) -> DetectTextRequest:
        return self._detect_text_request
