# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .contact import Contact


class Alert(object):
    _types = {
        "alert_id": int,
        "resource_scope": str,
        "monitor_target": int,
        "alert_strategy": str,
        "alert_time": int,
        "alert_level": int,
        "contacts": List[Contact],
        "notify_methods": List[int],
        "alert_rule": str,
        "process_time": int,
        "recover_time": int,
        "process_status": int,
        "alert_rule_id": int,
        "monitor_target_room_id": str,
        "monitor_target_room_mac": str,
    }

    def __init__(self, d=None):
        self.alert_id: Optional[int] = None
        self.resource_scope: Optional[str] = None
        self.monitor_target: Optional[int] = None
        self.alert_strategy: Optional[str] = None
        self.alert_time: Optional[int] = None
        self.alert_level: Optional[int] = None
        self.contacts: Optional[List[Contact]] = None
        self.notify_methods: Optional[List[int]] = None
        self.alert_rule: Optional[str] = None
        self.process_time: Optional[int] = None
        self.recover_time: Optional[int] = None
        self.process_status: Optional[int] = None
        self.alert_rule_id: Optional[int] = None
        self.monitor_target_room_id: Optional[str] = None
        self.monitor_target_room_mac: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AlertBuilder":
        return AlertBuilder()


class AlertBuilder(object):
    def __init__(self) -> None:
        self._alert = Alert()

    def alert_id(self, alert_id: int) -> "AlertBuilder":
        self._alert.alert_id = alert_id
        return self

    def resource_scope(self, resource_scope: str) -> "AlertBuilder":
        self._alert.resource_scope = resource_scope
        return self

    def monitor_target(self, monitor_target: int) -> "AlertBuilder":
        self._alert.monitor_target = monitor_target
        return self

    def alert_strategy(self, alert_strategy: str) -> "AlertBuilder":
        self._alert.alert_strategy = alert_strategy
        return self

    def alert_time(self, alert_time: int) -> "AlertBuilder":
        self._alert.alert_time = alert_time
        return self

    def alert_level(self, alert_level: int) -> "AlertBuilder":
        self._alert.alert_level = alert_level
        return self

    def contacts(self, contacts: List[Contact]) -> "AlertBuilder":
        self._alert.contacts = contacts
        return self

    def notify_methods(self, notify_methods: List[int]) -> "AlertBuilder":
        self._alert.notify_methods = notify_methods
        return self

    def alert_rule(self, alert_rule: str) -> "AlertBuilder":
        self._alert.alert_rule = alert_rule
        return self

    def process_time(self, process_time: int) -> "AlertBuilder":
        self._alert.process_time = process_time
        return self

    def recover_time(self, recover_time: int) -> "AlertBuilder":
        self._alert.recover_time = recover_time
        return self

    def process_status(self, process_status: int) -> "AlertBuilder":
        self._alert.process_status = process_status
        return self

    def alert_rule_id(self, alert_rule_id: int) -> "AlertBuilder":
        self._alert.alert_rule_id = alert_rule_id
        return self

    def monitor_target_room_id(self, monitor_target_room_id: str) -> "AlertBuilder":
        self._alert.monitor_target_room_id = monitor_target_room_id
        return self

    def monitor_target_room_mac(self, monitor_target_room_mac: str) -> "AlertBuilder":
        self._alert.monitor_target_room_mac = monitor_target_room_mac
        return self

    def build(self) -> "Alert":
        return self._alert
