# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .apply_reserve_request_body import ApplyReserveRequestBody


class ApplyReserveRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[ApplyReserveRequestBody] = None

    @staticmethod
    def builder() -> "ApplyReserveRequestBuilder":
        return ApplyReserveRequestBuilder()


class ApplyReserveRequestBuilder(object):

    def __init__(self) -> None:
        apply_reserve_request = ApplyReserveRequest()
        apply_reserve_request.http_method = HttpMethod.POST
        apply_reserve_request.uri = "/open-apis/vc/v1/reserves/apply"
        apply_reserve_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._apply_reserve_request: ApplyReserveRequest = apply_reserve_request

    def user_id_type(self, user_id_type: str) -> "ApplyReserveRequestBuilder":
        self._apply_reserve_request.user_id_type = user_id_type
        self._apply_reserve_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: ApplyReserveRequestBody) -> "ApplyReserveRequestBuilder":
        self._apply_reserve_request.request_body = request_body
        self._apply_reserve_request.body = request_body
        return self

    def build(self) -> ApplyReserveRequest:
        return self._apply_reserve_request
