# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .reserve_meeting_setting import ReserveMeetingSetting


class ApplyReserveRequestBody(object):
    _types = {
        "end_time": int,
        "owner_id": str,
        "meeting_settings": ReserveMeetingSetting,
    }

    def __init__(self, d=None):
        self.end_time: Optional[int] = None
        self.owner_id: Optional[str] = None
        self.meeting_settings: Optional[ReserveMeetingSetting] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplyReserveRequestBodyBuilder":
        return ApplyReserveRequestBodyBuilder()


class ApplyReserveRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._apply_reserve_request_body = ApplyReserveRequestBody()

    def end_time(self, end_time: int) -> "ApplyReserveRequestBodyBuilder":
        self._apply_reserve_request_body.end_time = end_time
        return self

    def owner_id(self, owner_id: str) -> "ApplyReserveRequestBodyBuilder":
        self._apply_reserve_request_body.owner_id = owner_id
        return self

    def meeting_settings(self, meeting_settings: ReserveMeetingSetting) -> "ApplyReserveRequestBodyBuilder":
        self._apply_reserve_request_body.meeting_settings = meeting_settings
        return self

    def build(self) -> "ApplyReserveRequestBody":
        return self._apply_reserve_request_body
