# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class Conditions(object):
    _types = {
        "custom_key": str,
        "option_keys": List[str],
    }

    def __init__(self, d=None):
        self.custom_key: Optional[str] = None
        self.option_keys: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ConditionsBuilder":
        return ConditionsBuilder()


class ConditionsBuilder(object):
    def __init__(self) -> None:
        self._conditions = Conditions()

    def custom_key(self, custom_key: str) -> "ConditionsBuilder":
        self._conditions.custom_key = custom_key
        return self

    def option_keys(self, option_keys: List[str]) -> "ConditionsBuilder":
        self._conditions.option_keys = option_keys
        return self

    def build(self) -> "Conditions":
        return self._conditions
