# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .scope_config import ScopeConfig


class CreateScopeConfigRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[ScopeConfig] = None

    @staticmethod
    def builder() -> "CreateScopeConfigRequestBuilder":
        return CreateScopeConfigRequestBuilder()


class CreateScopeConfigRequestBuilder(object):

    def __init__(self) -> None:
        create_scope_config_request = CreateScopeConfigRequest()
        create_scope_config_request.http_method = HttpMethod.POST
        create_scope_config_request.uri = "/open-apis/vc/v1/scope_config"
        create_scope_config_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_scope_config_request: CreateScopeConfigRequest = create_scope_config_request

    def user_id_type(self, user_id_type: str) -> "CreateScopeConfigRequestBuilder":
        self._create_scope_config_request.user_id_type = user_id_type
        self._create_scope_config_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: ScopeConfig) -> "CreateScopeConfigRequestBuilder":
        self._create_scope_config_request.request_body = request_body
        self._create_scope_config_request.body = request_body
        return self

    def build(self) -> CreateScopeConfigRequest:
        return self._create_scope_config_request
