# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteReserveRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.reserve_id: Optional[int] = None

    @staticmethod
    def builder() -> "DeleteReserveRequestBuilder":
        return DeleteReserveRequestBuilder()


class DeleteReserveRequestBuilder(object):

    def __init__(self) -> None:
        delete_reserve_request = DeleteReserveRequest()
        delete_reserve_request.http_method = HttpMethod.DELETE
        delete_reserve_request.uri = "/open-apis/vc/v1/reserves/:reserve_id"
        delete_reserve_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._delete_reserve_request: DeleteReserveRequest = delete_reserve_request

    def reserve_id(self, reserve_id: int) -> "DeleteReserveRequestBuilder":
        self._delete_reserve_request.reserve_id = reserve_id
        self._delete_reserve_request.paths["reserve_id"] = str(reserve_id)
        return self

    def build(self) -> DeleteReserveRequest:
        return self._delete_reserve_request
