# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteRoomRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.room_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteRoomRequestBuilder":
        return DeleteRoomRequestBuilder()


class DeleteRoomRequestBuilder(object):

    def __init__(self) -> None:
        delete_room_request = DeleteRoomRequest()
        delete_room_request.http_method = HttpMethod.DELETE
        delete_room_request.uri = "/open-apis/vc/v1/rooms/:room_id"
        delete_room_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_room_request: DeleteRoomRequest = delete_room_request

    def room_id(self, room_id: str) -> "DeleteRoomRequestBuilder":
        self._delete_room_request.room_id = room_id
        self._delete_room_request.paths["room_id"] = str(room_id)
        return self

    def build(self) -> DeleteRoomRequest:
        return self._delete_room_request
