# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DownloadExportRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.file_token: Optional[str] = None

    @staticmethod
    def builder() -> "DownloadExportRequestBuilder":
        return DownloadExportRequestBuilder()


class DownloadExportRequestBuilder(object):

    def __init__(self) -> None:
        download_export_request = DownloadExportRequest()
        download_export_request.http_method = HttpMethod.GET
        download_export_request.uri = "/open-apis/vc/v1/exports/download"
        download_export_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._download_export_request: DownloadExportRequest = download_export_request

    def file_token(self, file_token: str) -> "DownloadExportRequestBuilder":
        self._download_export_request.file_token = file_token
        self._download_export_request.add_query("file_token", file_token)
        return self

    def build(self) -> DownloadExportRequest:
        return self._download_export_request
