# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetDailyReportRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None

    @staticmethod
    def builder() -> "GetDailyReportRequestBuilder":
        return GetDailyReportRequestBuilder()


class GetDailyReportRequestBuilder(object):

    def __init__(self) -> None:
        get_daily_report_request = GetDailyReportRequest()
        get_daily_report_request.http_method = HttpMethod.GET
        get_daily_report_request.uri = "/open-apis/vc/v1/reports/get_daily"
        get_daily_report_request.token_types = {AccessTokenType.TENANT}
        self._get_daily_report_request: GetDailyReportRequest = get_daily_report_request

    def start_time(self, start_time: int) -> "GetDailyReportRequestBuilder":
        self._get_daily_report_request.start_time = start_time
        self._get_daily_report_request.add_query("start_time", start_time)
        return self

    def end_time(self, end_time: int) -> "GetDailyReportRequestBuilder":
        self._get_daily_report_request.end_time = end_time
        self._get_daily_report_request.add_query("end_time", end_time)
        return self

    def build(self) -> GetDailyReportRequest:
        return self._get_daily_report_request
