# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetExportRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.task_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetExportRequestBuilder":
        return GetExportRequestBuilder()


class GetExportRequestBuilder(object):

    def __init__(self) -> None:
        get_export_request = GetExportRequest()
        get_export_request.http_method = HttpMethod.GET
        get_export_request.uri = "/open-apis/vc/v1/exports/:task_id"
        get_export_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_export_request: GetExportRequest = get_export_request

    def task_id(self, task_id: str) -> "GetExportRequestBuilder":
        self._get_export_request.task_id = task_id
        self._get_export_request.paths["task_id"] = str(task_id)
        return self

    def build(self) -> GetExportRequest:
        return self._get_export_request
