# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetMeetingRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.with_participants: Optional[bool] = None
        self.with_meeting_ability: Optional[bool] = None
        self.user_id_type: Optional[str] = None
        self.meeting_id: Optional[int] = None

    @staticmethod
    def builder() -> "GetMeetingRequestBuilder":
        return GetMeetingRequestBuilder()


class GetMeetingRequestBuilder(object):

    def __init__(self) -> None:
        get_meeting_request = GetMeetingRequest()
        get_meeting_request.http_method = HttpMethod.GET
        get_meeting_request.uri = "/open-apis/vc/v1/meetings/:meeting_id"
        get_meeting_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._get_meeting_request: GetMeetingRequest = get_meeting_request

    def with_participants(self, with_participants: bool) -> "GetMeetingRequestBuilder":
        self._get_meeting_request.with_participants = with_participants
        self._get_meeting_request.add_query("with_participants", with_participants)
        return self

    def with_meeting_ability(self, with_meeting_ability: bool) -> "GetMeetingRequestBuilder":
        self._get_meeting_request.with_meeting_ability = with_meeting_ability
        self._get_meeting_request.add_query("with_meeting_ability", with_meeting_ability)
        return self

    def user_id_type(self, user_id_type: str) -> "GetMeetingRequestBuilder":
        self._get_meeting_request.user_id_type = user_id_type
        self._get_meeting_request.add_query("user_id_type", user_id_type)
        return self

    def meeting_id(self, meeting_id: int) -> "GetMeetingRequestBuilder":
        self._get_meeting_request.meeting_id = meeting_id
        self._get_meeting_request.paths["meeting_id"] = str(meeting_id)
        return self

    def build(self) -> GetMeetingRequest:
        return self._get_meeting_request
