# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetResourceReservationListRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.room_level_id: Optional[str] = None
        self.need_topic: Optional[bool] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.room_ids: Optional[List[str]] = None
        self.is_exclude: Optional[bool] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None

    @staticmethod
    def builder() -> "GetResourceReservationListRequestBuilder":
        return GetResourceReservationListRequestBuilder()


class GetResourceReservationListRequestBuilder(object):

    def __init__(self) -> None:
        get_resource_reservation_list_request = GetResourceReservationListRequest()
        get_resource_reservation_list_request.http_method = HttpMethod.GET
        get_resource_reservation_list_request.uri = "/open-apis/vc/v1/resource_reservation_list"
        get_resource_reservation_list_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_resource_reservation_list_request: GetResourceReservationListRequest = get_resource_reservation_list_request

    def room_level_id(self, room_level_id: str) -> "GetResourceReservationListRequestBuilder":
        self._get_resource_reservation_list_request.room_level_id = room_level_id
        self._get_resource_reservation_list_request.add_query("room_level_id", room_level_id)
        return self

    def need_topic(self, need_topic: bool) -> "GetResourceReservationListRequestBuilder":
        self._get_resource_reservation_list_request.need_topic = need_topic
        self._get_resource_reservation_list_request.add_query("need_topic", need_topic)
        return self

    def start_time(self, start_time: int) -> "GetResourceReservationListRequestBuilder":
        self._get_resource_reservation_list_request.start_time = start_time
        self._get_resource_reservation_list_request.add_query("start_time", start_time)
        return self

    def end_time(self, end_time: int) -> "GetResourceReservationListRequestBuilder":
        self._get_resource_reservation_list_request.end_time = end_time
        self._get_resource_reservation_list_request.add_query("end_time", end_time)
        return self

    def room_ids(self, room_ids: List[str]) -> "GetResourceReservationListRequestBuilder":
        self._get_resource_reservation_list_request.room_ids = room_ids
        self._get_resource_reservation_list_request.add_query("room_ids", room_ids)
        return self

    def is_exclude(self, is_exclude: bool) -> "GetResourceReservationListRequestBuilder":
        self._get_resource_reservation_list_request.is_exclude = is_exclude
        self._get_resource_reservation_list_request.add_query("is_exclude", is_exclude)
        return self

    def page_size(self, page_size: int) -> "GetResourceReservationListRequestBuilder":
        self._get_resource_reservation_list_request.page_size = page_size
        self._get_resource_reservation_list_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "GetResourceReservationListRequestBuilder":
        self._get_resource_reservation_list_request.page_token = page_token
        self._get_resource_reservation_list_request.add_query("page_token", page_token)
        return self

    def build(self) -> GetResourceReservationListRequest:
        return self._get_resource_reservation_list_request
