# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .room_meeting_reservation import RoomMeetingReservation


class GetResourceReservationListResponseBody(object):
    _types = {
        "room_reservation_list": List[RoomMeetingReservation],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.room_reservation_list: Optional[List[RoomMeetingReservation]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "GetResourceReservationListResponseBodyBuilder":
        return GetResourceReservationListResponseBodyBuilder()


class GetResourceReservationListResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._get_resource_reservation_list_response_body = GetResourceReservationListResponseBody()

    def room_reservation_list(self, room_reservation_list: List[
        RoomMeetingReservation]) -> "GetResourceReservationListResponseBodyBuilder":
        self._get_resource_reservation_list_response_body.room_reservation_list = room_reservation_list
        return self

    def page_token(self, page_token: str) -> "GetResourceReservationListResponseBodyBuilder":
        self._get_resource_reservation_list_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "GetResourceReservationListResponseBodyBuilder":
        self._get_resource_reservation_list_response_body.has_more = has_more
        return self

    def build(self) -> "GetResourceReservationListResponseBody":
        return self._get_resource_reservation_list_response_body
