# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetRoomLevelRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.room_level_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetRoomLevelRequestBuilder":
        return GetRoomLevelRequestBuilder()


class GetRoomLevelRequestBuilder(object):

    def __init__(self) -> None:
        get_room_level_request = GetRoomLevelRequest()
        get_room_level_request.http_method = HttpMethod.GET
        get_room_level_request.uri = "/open-apis/vc/v1/room_levels/:room_level_id"
        get_room_level_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_room_level_request: GetRoomLevelRequest = get_room_level_request

    def room_level_id(self, room_level_id: str) -> "GetRoomLevelRequestBuilder":
        self._get_room_level_request.room_level_id = room_level_id
        self._get_room_level_request.paths["room_level_id"] = str(room_level_id)
        return self

    def build(self) -> GetRoomLevelRequest:
        return self._get_room_level_request
