# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetScopeConfigRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.scope_type: Optional[int] = None
        self.scope_id: Optional[str] = None
        self.user_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "GetScopeConfigRequestBuilder":
        return GetScopeConfigRequestBuilder()


class GetScopeConfigRequestBuilder(object):

    def __init__(self) -> None:
        get_scope_config_request = GetScopeConfigRequest()
        get_scope_config_request.http_method = HttpMethod.GET
        get_scope_config_request.uri = "/open-apis/vc/v1/scope_config"
        get_scope_config_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_scope_config_request: GetScopeConfigRequest = get_scope_config_request

    def scope_type(self, scope_type: int) -> "GetScopeConfigRequestBuilder":
        self._get_scope_config_request.scope_type = scope_type
        self._get_scope_config_request.add_query("scope_type", scope_type)
        return self

    def scope_id(self, scope_id: str) -> "GetScopeConfigRequestBuilder":
        self._get_scope_config_request.scope_id = scope_id
        self._get_scope_config_request.add_query("scope_id", scope_id)
        return self

    def user_id_type(self, user_id_type: str) -> "GetScopeConfigRequestBuilder":
        self._get_scope_config_request.user_id_type = user_id_type
        self._get_scope_config_request.add_query("user_id_type", user_id_type)
        return self

    def build(self) -> GetScopeConfigRequest:
        return self._get_scope_config_request
