# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .kickout_meeting_request_body import KickoutMeetingRequestBody


class KickoutMeetingRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.meeting_id: Optional[int] = None
        self.request_body: Optional[KickoutMeetingRequestBody] = None

    @staticmethod
    def builder() -> "KickoutMeetingRequestBuilder":
        return KickoutMeetingRequestBuilder()


class KickoutMeetingRequestBuilder(object):

    def __init__(self) -> None:
        kickout_meeting_request = KickoutMeetingRequest()
        kickout_meeting_request.http_method = HttpMethod.POST
        kickout_meeting_request.uri = "/open-apis/vc/v1/meetings/:meeting_id/kickout"
        kickout_meeting_request.token_types = {AccessTokenType.TENANT}
        self._kickout_meeting_request: KickoutMeetingRequest = kickout_meeting_request

    def user_id_type(self, user_id_type: str) -> "KickoutMeetingRequestBuilder":
        self._kickout_meeting_request.user_id_type = user_id_type
        self._kickout_meeting_request.add_query("user_id_type", user_id_type)
        return self

    def meeting_id(self, meeting_id: int) -> "KickoutMeetingRequestBuilder":
        self._kickout_meeting_request.meeting_id = meeting_id
        self._kickout_meeting_request.paths["meeting_id"] = str(meeting_id)
        return self

    def request_body(self, request_body: KickoutMeetingRequestBody) -> "KickoutMeetingRequestBuilder":
        self._kickout_meeting_request.request_body = request_body
        self._kickout_meeting_request.body = request_body
        return self

    def build(self) -> KickoutMeetingRequest:
        return self._kickout_meeting_request
