# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListAlertRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.query_type: Optional[int] = None
        self.query_value: Optional[str] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListAlertRequestBuilder":
        return ListAlertRequestBuilder()


class ListAlertRequestBuilder(object):

    def __init__(self) -> None:
        list_alert_request = ListAlertRequest()
        list_alert_request.http_method = HttpMethod.GET
        list_alert_request.uri = "/open-apis/vc/v1/alerts"
        list_alert_request.token_types = {AccessTokenType.TENANT}
        self._list_alert_request: ListAlertRequest = list_alert_request

    def start_time(self, start_time: int) -> "ListAlertRequestBuilder":
        self._list_alert_request.start_time = start_time
        self._list_alert_request.add_query("start_time", start_time)
        return self

    def end_time(self, end_time: int) -> "ListAlertRequestBuilder":
        self._list_alert_request.end_time = end_time
        self._list_alert_request.add_query("end_time", end_time)
        return self

    def query_type(self, query_type: int) -> "ListAlertRequestBuilder":
        self._list_alert_request.query_type = query_type
        self._list_alert_request.add_query("query_type", query_type)
        return self

    def query_value(self, query_value: str) -> "ListAlertRequestBuilder":
        self._list_alert_request.query_value = query_value
        self._list_alert_request.add_query("query_value", query_value)
        return self

    def page_size(self, page_size: int) -> "ListAlertRequestBuilder":
        self._list_alert_request.page_size = page_size
        self._list_alert_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListAlertRequestBuilder":
        self._list_alert_request.page_token = page_token
        self._list_alert_request.add_query("page_token", page_token)
        return self

    def build(self) -> ListAlertRequest:
        return self._list_alert_request
