# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .alert import Alert


class ListAlertResponseBody(object):
    _types = {
        "has_more": bool,
        "page_token": str,
        "items": List[Alert],
    }

    def __init__(self, d=None):
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.items: Optional[List[Alert]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListAlertResponseBodyBuilder":
        return ListAlertResponseBodyBuilder()


class ListAlertResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_alert_response_body = ListAlertResponseBody()

    def has_more(self, has_more: bool) -> "ListAlertResponseBodyBuilder":
        self._list_alert_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListAlertResponseBodyBuilder":
        self._list_alert_response_body.page_token = page_token
        return self

    def items(self, items: List[Alert]) -> "ListAlertResponseBodyBuilder":
        self._list_alert_response_body.items = items
        return self

    def build(self) -> "ListAlertResponseBody":
        return self._list_alert_response_body
