# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .room import Room


class ListRoomResponseBody(object):
    _types = {
        "rooms": List[Room],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.rooms: Optional[List[Room]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListRoomResponseBodyBuilder":
        return ListRoomResponseBodyBuilder()


class ListRoomResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_room_response_body = ListRoomResponseBody()

    def rooms(self, rooms: List[Room]) -> "ListRoomResponseBodyBuilder":
        self._list_room_response_body.rooms = rooms
        return self

    def page_token(self, page_token: str) -> "ListRoomResponseBodyBuilder":
        self._list_room_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListRoomResponseBodyBuilder":
        self._list_room_response_body.has_more = has_more
        return self

    def build(self) -> "ListRoomResponseBody":
        return self._list_room_response_body
