# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Material(object):
    _types = {
        "name": str,
        "file_token": str,
        "file_size": int,
        "device_type": int,
        "material_type": int,
        "review_result": int,
        "material_source": int,
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.file_token: Optional[str] = None
        self.file_size: Optional[int] = None
        self.device_type: Optional[int] = None
        self.material_type: Optional[int] = None
        self.review_result: Optional[int] = None
        self.material_source: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MaterialBuilder":
        return MaterialBuilder()


class MaterialBuilder(object):
    def __init__(self) -> None:
        self._material = Material()

    def name(self, name: str) -> "MaterialBuilder":
        self._material.name = name
        return self

    def file_token(self, file_token: str) -> "MaterialBuilder":
        self._material.file_token = file_token
        return self

    def file_size(self, file_size: int) -> "MaterialBuilder":
        self._material.file_size = file_size
        return self

    def device_type(self, device_type: int) -> "MaterialBuilder":
        self._material.device_type = device_type
        return self

    def material_type(self, material_type: int) -> "MaterialBuilder":
        self._material.material_type = material_type
        return self

    def review_result(self, review_result: int) -> "MaterialBuilder":
        self._material.review_result = review_result
        return self

    def material_source(self, material_source: int) -> "MaterialBuilder":
        self._material.material_source = material_source
        return self

    def build(self) -> "Material":
        return self._material
