# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .meeting_ability import MeetingAbility
from .meeting_participant import MeetingParticipant
from .meeting_user import MeetingUser


class Meeting(object):
    _types = {
        "id": int,
        "topic": str,
        "url": str,
        "meeting_no": str,
        "create_time": int,
        "start_time": int,
        "end_time": int,
        "host_user": MeetingUser,
        "status": int,
        "participant_count": int,
        "participant_count_accumulated": int,
        "participants": List[MeetingParticipant],
        "ability": MeetingAbility,
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.topic: Optional[str] = None
        self.url: Optional[str] = None
        self.meeting_no: Optional[str] = None
        self.create_time: Optional[int] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.host_user: Optional[MeetingUser] = None
        self.status: Optional[int] = None
        self.participant_count: Optional[int] = None
        self.participant_count_accumulated: Optional[int] = None
        self.participants: Optional[List[MeetingParticipant]] = None
        self.ability: Optional[MeetingAbility] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MeetingBuilder":
        return MeetingBuilder()


class MeetingBuilder(object):
    def __init__(self) -> None:
        self._meeting = Meeting()

    def id(self, id: int) -> "MeetingBuilder":
        self._meeting.id = id
        return self

    def topic(self, topic: str) -> "MeetingBuilder":
        self._meeting.topic = topic
        return self

    def url(self, url: str) -> "MeetingBuilder":
        self._meeting.url = url
        return self

    def meeting_no(self, meeting_no: str) -> "MeetingBuilder":
        self._meeting.meeting_no = meeting_no
        return self

    def create_time(self, create_time: int) -> "MeetingBuilder":
        self._meeting.create_time = create_time
        return self

    def start_time(self, start_time: int) -> "MeetingBuilder":
        self._meeting.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "MeetingBuilder":
        self._meeting.end_time = end_time
        return self

    def host_user(self, host_user: MeetingUser) -> "MeetingBuilder":
        self._meeting.host_user = host_user
        return self

    def status(self, status: int) -> "MeetingBuilder":
        self._meeting.status = status
        return self

    def participant_count(self, participant_count: int) -> "MeetingBuilder":
        self._meeting.participant_count = participant_count
        return self

    def participant_count_accumulated(self, participant_count_accumulated: int) -> "MeetingBuilder":
        self._meeting.participant_count_accumulated = participant_count_accumulated
        return self

    def participants(self, participants: List[MeetingParticipant]) -> "MeetingBuilder":
        self._meeting.participants = participants
        return self

    def ability(self, ability: MeetingAbility) -> "MeetingBuilder":
        self._meeting.ability = ability
        return self

    def build(self) -> "Meeting":
        return self._meeting
