# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .meeting_event_user import MeetingEventUser


class MeetingEventMeeting(object):
    _types = {
        "id": int,
        "topic": str,
        "meeting_no": str,
        "meeting_source": int,
        "start_time": int,
        "end_time": int,
        "host_user": MeetingEventUser,
        "owner": MeetingEventUser,
        "calendar_event_id": str,
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.topic: Optional[str] = None
        self.meeting_no: Optional[str] = None
        self.meeting_source: Optional[int] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.host_user: Optional[MeetingEventUser] = None
        self.owner: Optional[MeetingEventUser] = None
        self.calendar_event_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MeetingEventMeetingBuilder":
        return MeetingEventMeetingBuilder()


class MeetingEventMeetingBuilder(object):
    def __init__(self) -> None:
        self._meeting_event_meeting = MeetingEventMeeting()

    def id(self, id: int) -> "MeetingEventMeetingBuilder":
        self._meeting_event_meeting.id = id
        return self

    def topic(self, topic: str) -> "MeetingEventMeetingBuilder":
        self._meeting_event_meeting.topic = topic
        return self

    def meeting_no(self, meeting_no: str) -> "MeetingEventMeetingBuilder":
        self._meeting_event_meeting.meeting_no = meeting_no
        return self

    def meeting_source(self, meeting_source: int) -> "MeetingEventMeetingBuilder":
        self._meeting_event_meeting.meeting_source = meeting_source
        return self

    def start_time(self, start_time: int) -> "MeetingEventMeetingBuilder":
        self._meeting_event_meeting.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "MeetingEventMeetingBuilder":
        self._meeting_event_meeting.end_time = end_time
        return self

    def host_user(self, host_user: MeetingEventUser) -> "MeetingEventMeetingBuilder":
        self._meeting_event_meeting.host_user = host_user
        return self

    def owner(self, owner: MeetingEventUser) -> "MeetingEventMeetingBuilder":
        self._meeting_event_meeting.owner = owner
        return self

    def calendar_event_id(self, calendar_event_id: str) -> "MeetingEventMeetingBuilder":
        self._meeting_event_meeting.calendar_event_id = calendar_event_id
        return self

    def build(self) -> "MeetingEventMeeting":
        return self._meeting_event_meeting
