# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .user_id import UserId


class MeetingEventUser(object):
    _types = {
        "id": UserId,
        "user_role": int,
        "user_type": int,
    }

    def __init__(self, d=None):
        self.id: Optional[UserId] = None
        self.user_role: Optional[int] = None
        self.user_type: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MeetingEventUserBuilder":
        return MeetingEventUserBuilder()


class MeetingEventUserBuilder(object):
    def __init__(self) -> None:
        self._meeting_event_user = MeetingEventUser()

    def id(self, id: UserId) -> "MeetingEventUserBuilder":
        self._meeting_event_user.id = id
        return self

    def user_role(self, user_role: int) -> "MeetingEventUserBuilder":
        self._meeting_event_user.user_role = user_role
        return self

    def user_type(self, user_type: int) -> "MeetingEventUserBuilder":
        self._meeting_event_user.user_type = user_type
        return self

    def build(self) -> "MeetingEventUser":
        return self._meeting_event_user
