# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class MeetingParticipant(object):
    _types = {
        "id": str,
        "first_join_time": int,
        "final_leave_time": int,
        "in_meeting_duration": int,
        "user_type": int,
        "is_host": bool,
        "is_cohost": bool,
        "is_external": bool,
        "status": int,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.first_join_time: Optional[int] = None
        self.final_leave_time: Optional[int] = None
        self.in_meeting_duration: Optional[int] = None
        self.user_type: Optional[int] = None
        self.is_host: Optional[bool] = None
        self.is_cohost: Optional[bool] = None
        self.is_external: Optional[bool] = None
        self.status: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MeetingParticipantBuilder":
        return MeetingParticipantBuilder()


class MeetingParticipantBuilder(object):
    def __init__(self) -> None:
        self._meeting_participant = MeetingParticipant()

    def id(self, id: str) -> "MeetingParticipantBuilder":
        self._meeting_participant.id = id
        return self

    def first_join_time(self, first_join_time: int) -> "MeetingParticipantBuilder":
        self._meeting_participant.first_join_time = first_join_time
        return self

    def final_leave_time(self, final_leave_time: int) -> "MeetingParticipantBuilder":
        self._meeting_participant.final_leave_time = final_leave_time
        return self

    def in_meeting_duration(self, in_meeting_duration: int) -> "MeetingParticipantBuilder":
        self._meeting_participant.in_meeting_duration = in_meeting_duration
        return self

    def user_type(self, user_type: int) -> "MeetingParticipantBuilder":
        self._meeting_participant.user_type = user_type
        return self

    def is_host(self, is_host: bool) -> "MeetingParticipantBuilder":
        self._meeting_participant.is_host = is_host
        return self

    def is_cohost(self, is_cohost: bool) -> "MeetingParticipantBuilder":
        self._meeting_participant.is_cohost = is_cohost
        return self

    def is_external(self, is_external: bool) -> "MeetingParticipantBuilder":
        self._meeting_participant.is_external = is_external
        return self

    def status(self, status: int) -> "MeetingParticipantBuilder":
        self._meeting_participant.status = status
        return self

    def build(self) -> "MeetingParticipant":
        return self._meeting_participant
