# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class MeetingRecording(object):
    _types = {
        "id": int,
        "meeting_id": int,
        "url": str,
        "duration": int,
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.meeting_id: Optional[int] = None
        self.url: Optional[str] = None
        self.duration: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MeetingRecordingBuilder":
        return MeetingRecordingBuilder()


class MeetingRecordingBuilder(object):
    def __init__(self) -> None:
        self._meeting_recording = MeetingRecording()

    def id(self, id: int) -> "MeetingRecordingBuilder":
        self._meeting_recording.id = id
        return self

    def meeting_id(self, meeting_id: int) -> "MeetingRecordingBuilder":
        self._meeting_recording.meeting_id = meeting_id
        return self

    def url(self, url: str) -> "MeetingRecordingBuilder":
        self._meeting_recording.url = url
        return self

    def duration(self, duration: int) -> "MeetingRecordingBuilder":
        self._meeting_recording.duration = duration
        return self

    def build(self) -> "MeetingRecording":
        return self._meeting_recording
