# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .my_ai_object_context import MyAiObjectContext
from .my_ai_plugin_context import MyAiPluginContext
from .my_ai_vc_meeting_extra import MyAiVcMeetingExtra


class MyAiVcMeetingScenarioContext(object):
    _types = {
        "plugins": List[MyAiPluginContext],
        "object": MyAiObjectContext,
        "work_mode": int,
        "scenario": str,
        "extra": MyAiVcMeetingExtra,
    }

    def __init__(self, d=None):
        self.plugins: Optional[List[MyAiPluginContext]] = None
        self.object: Optional[MyAiObjectContext] = None
        self.work_mode: Optional[int] = None
        self.scenario: Optional[str] = None
        self.extra: Optional[MyAiVcMeetingExtra] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MyAiVcMeetingScenarioContextBuilder":
        return MyAiVcMeetingScenarioContextBuilder()


class MyAiVcMeetingScenarioContextBuilder(object):
    def __init__(self) -> None:
        self._my_ai_vc_meeting_scenario_context = MyAiVcMeetingScenarioContext()

    def plugins(self, plugins: List[MyAiPluginContext]) -> "MyAiVcMeetingScenarioContextBuilder":
        self._my_ai_vc_meeting_scenario_context.plugins = plugins
        return self

    def object(self, object: MyAiObjectContext) -> "MyAiVcMeetingScenarioContextBuilder":
        self._my_ai_vc_meeting_scenario_context.object = object
        return self

    def work_mode(self, work_mode: int) -> "MyAiVcMeetingScenarioContextBuilder":
        self._my_ai_vc_meeting_scenario_context.work_mode = work_mode
        return self

    def scenario(self, scenario: str) -> "MyAiVcMeetingScenarioContextBuilder":
        self._my_ai_vc_meeting_scenario_context.scenario = scenario
        return self

    def extra(self, extra: MyAiVcMeetingExtra) -> "MyAiVcMeetingScenarioContextBuilder":
        self._my_ai_vc_meeting_scenario_context.extra = extra
        return self

    def build(self) -> "MyAiVcMeetingScenarioContext":
        return self._my_ai_vc_meeting_scenario_context
