# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .participant_list_export_request_body import ParticipantListExportRequestBody


class ParticipantListExportRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[ParticipantListExportRequestBody] = None

    @staticmethod
    def builder() -> "ParticipantListExportRequestBuilder":
        return ParticipantListExportRequestBuilder()


class ParticipantListExportRequestBuilder(object):

    def __init__(self) -> None:
        participant_list_export_request = ParticipantListExportRequest()
        participant_list_export_request.http_method = HttpMethod.POST
        participant_list_export_request.uri = "/open-apis/vc/v1/exports/participant_list"
        participant_list_export_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._participant_list_export_request: ParticipantListExportRequest = participant_list_export_request

    def user_id_type(self, user_id_type: str) -> "ParticipantListExportRequestBuilder":
        self._participant_list_export_request.user_id_type = user_id_type
        self._participant_list_export_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: ParticipantListExportRequestBody) -> "ParticipantListExportRequestBuilder":
        self._participant_list_export_request.request_body = request_body
        self._participant_list_export_request.body = request_body
        return self

    def build(self) -> ParticipantListExportRequest:
        return self._participant_list_export_request
