# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .quality_audio import QualityAudio
from .quality_cpu_usage import QualityCpuUsage
from .quality_network import QualityNetwork
from .quality_video_sharing import QualityVideoSharing


class ParticipantQuality(object):
    _types = {
        "network": QualityNetwork,
        "audio": QualityAudio,
        "video": QualityVideoSharing,
        "screen_sharing": QualityVideoSharing,
        "cpu_usage": QualityCpuUsage,
    }

    def __init__(self, d=None):
        self.network: Optional[QualityNetwork] = None
        self.audio: Optional[QualityAudio] = None
        self.video: Optional[QualityVideoSharing] = None
        self.screen_sharing: Optional[QualityVideoSharing] = None
        self.cpu_usage: Optional[QualityCpuUsage] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ParticipantQualityBuilder":
        return ParticipantQualityBuilder()


class ParticipantQualityBuilder(object):
    def __init__(self) -> None:
        self._participant_quality = ParticipantQuality()

    def network(self, network: QualityNetwork) -> "ParticipantQualityBuilder":
        self._participant_quality.network = network
        return self

    def audio(self, audio: QualityAudio) -> "ParticipantQualityBuilder":
        self._participant_quality.audio = audio
        return self

    def video(self, video: QualityVideoSharing) -> "ParticipantQualityBuilder":
        self._participant_quality.video = video
        return self

    def screen_sharing(self, screen_sharing: QualityVideoSharing) -> "ParticipantQualityBuilder":
        self._participant_quality.screen_sharing = screen_sharing
        return self

    def cpu_usage(self, cpu_usage: QualityCpuUsage) -> "ParticipantQualityBuilder":
        self._participant_quality.cpu_usage = cpu_usage
        return self

    def build(self) -> "ParticipantQuality":
        return self._participant_quality
