# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ParticipantQualityListExportRequestBody(object):
    _types = {
        "meeting_start_time": int,
        "meeting_end_time": int,
        "meeting_no": str,
        "join_time": int,
        "user_id": str,
        "room_id": str,
    }

    def __init__(self, d=None):
        self.meeting_start_time: Optional[int] = None
        self.meeting_end_time: Optional[int] = None
        self.meeting_no: Optional[str] = None
        self.join_time: Optional[int] = None
        self.user_id: Optional[str] = None
        self.room_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ParticipantQualityListExportRequestBodyBuilder":
        return ParticipantQualityListExportRequestBodyBuilder()


class ParticipantQualityListExportRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._participant_quality_list_export_request_body = ParticipantQualityListExportRequestBody()

    def meeting_start_time(self, meeting_start_time: int) -> "ParticipantQualityListExportRequestBodyBuilder":
        self._participant_quality_list_export_request_body.meeting_start_time = meeting_start_time
        return self

    def meeting_end_time(self, meeting_end_time: int) -> "ParticipantQualityListExportRequestBodyBuilder":
        self._participant_quality_list_export_request_body.meeting_end_time = meeting_end_time
        return self

    def meeting_no(self, meeting_no: str) -> "ParticipantQualityListExportRequestBodyBuilder":
        self._participant_quality_list_export_request_body.meeting_no = meeting_no
        return self

    def join_time(self, join_time: int) -> "ParticipantQualityListExportRequestBodyBuilder":
        self._participant_quality_list_export_request_body.join_time = join_time
        return self

    def user_id(self, user_id: str) -> "ParticipantQualityListExportRequestBodyBuilder":
        self._participant_quality_list_export_request_body.user_id = user_id
        return self

    def room_id(self, room_id: str) -> "ParticipantQualityListExportRequestBodyBuilder":
        self._participant_quality_list_export_request_body.room_id = room_id
        return self

    def build(self) -> "ParticipantQualityListExportRequestBody":
        return self._participant_quality_list_export_request_body
