# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_reserve_config_admin_request_body import PatchReserveConfigAdminRequestBody


class PatchReserveConfigAdminRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.reserve_config_id: Optional[str] = None
        self.request_body: Optional[PatchReserveConfigAdminRequestBody] = None

    @staticmethod
    def builder() -> "PatchReserveConfigAdminRequestBuilder":
        return PatchReserveConfigAdminRequestBuilder()


class PatchReserveConfigAdminRequestBuilder(object):

    def __init__(self) -> None:
        patch_reserve_config_admin_request = PatchReserveConfigAdminRequest()
        patch_reserve_config_admin_request.http_method = HttpMethod.PATCH
        patch_reserve_config_admin_request.uri = "/open-apis/vc/v1/reserve_configs/:reserve_config_id/admin"
        patch_reserve_config_admin_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_reserve_config_admin_request: PatchReserveConfigAdminRequest = patch_reserve_config_admin_request

    def user_id_type(self, user_id_type: str) -> "PatchReserveConfigAdminRequestBuilder":
        self._patch_reserve_config_admin_request.user_id_type = user_id_type
        self._patch_reserve_config_admin_request.add_query("user_id_type", user_id_type)
        return self

    def reserve_config_id(self, reserve_config_id: str) -> "PatchReserveConfigAdminRequestBuilder":
        self._patch_reserve_config_admin_request.reserve_config_id = reserve_config_id
        self._patch_reserve_config_admin_request.paths["reserve_config_id"] = str(reserve_config_id)
        return self

    def request_body(self, request_body: PatchReserveConfigAdminRequestBody) -> "PatchReserveConfigAdminRequestBuilder":
        self._patch_reserve_config_admin_request.request_body = request_body
        self._patch_reserve_config_admin_request.body = request_body
        return self

    def build(self) -> PatchReserveConfigAdminRequest:
        return self._patch_reserve_config_admin_request
