# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .reserve_form_config import ReserveFormConfig


class PatchReserveConfigFormRequestBody(object):
    _types = {
        "scope_type": int,
        "reserve_form_config": ReserveFormConfig,
    }

    def __init__(self, d=None):
        self.scope_type: Optional[int] = None
        self.reserve_form_config: Optional[ReserveFormConfig] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchReserveConfigFormRequestBodyBuilder":
        return PatchReserveConfigFormRequestBodyBuilder()


class PatchReserveConfigFormRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_reserve_config_form_request_body = PatchReserveConfigFormRequestBody()

    def scope_type(self, scope_type: int) -> "PatchReserveConfigFormRequestBodyBuilder":
        self._patch_reserve_config_form_request_body.scope_type = scope_type
        return self

    def reserve_form_config(self, reserve_form_config: ReserveFormConfig) -> "PatchReserveConfigFormRequestBodyBuilder":
        self._patch_reserve_config_form_request_body.reserve_form_config = reserve_form_config
        return self

    def build(self) -> "PatchReserveConfigFormRequestBody":
        return self._patch_reserve_config_form_request_body
