# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .approval_config import ApprovalConfig
from .reserve_scope_config import ReserveScopeConfig
from .time_config import TimeConfig


class PatchReserveConfigRequestBody(object):
    _types = {
        "scope_type": int,
        "approval_config": ApprovalConfig,
        "time_config": TimeConfig,
        "reserve_scope_config": ReserveScopeConfig,
    }

    def __init__(self, d=None):
        self.scope_type: Optional[int] = None
        self.approval_config: Optional[ApprovalConfig] = None
        self.time_config: Optional[TimeConfig] = None
        self.reserve_scope_config: Optional[ReserveScopeConfig] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchReserveConfigRequestBodyBuilder":
        return PatchReserveConfigRequestBodyBuilder()


class PatchReserveConfigRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_reserve_config_request_body = PatchReserveConfigRequestBody()

    def scope_type(self, scope_type: int) -> "PatchReserveConfigRequestBodyBuilder":
        self._patch_reserve_config_request_body.scope_type = scope_type
        return self

    def approval_config(self, approval_config: ApprovalConfig) -> "PatchReserveConfigRequestBodyBuilder":
        self._patch_reserve_config_request_body.approval_config = approval_config
        return self

    def time_config(self, time_config: TimeConfig) -> "PatchReserveConfigRequestBodyBuilder":
        self._patch_reserve_config_request_body.time_config = time_config
        return self

    def reserve_scope_config(self, reserve_scope_config: ReserveScopeConfig) -> "PatchReserveConfigRequestBodyBuilder":
        self._patch_reserve_config_request_body.reserve_scope_config = reserve_scope_config
        return self

    def build(self) -> "PatchReserveConfigRequestBody":
        return self._patch_reserve_config_request_body
