# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .room_level import RoomLevel


class PatchRoomLevelRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.room_level_id: Optional[str] = None
        self.request_body: Optional[RoomLevel] = None

    @staticmethod
    def builder() -> "PatchRoomLevelRequestBuilder":
        return PatchRoomLevelRequestBuilder()


class PatchRoomLevelRequestBuilder(object):

    def __init__(self) -> None:
        patch_room_level_request = PatchRoomLevelRequest()
        patch_room_level_request.http_method = HttpMethod.PATCH
        patch_room_level_request.uri = "/open-apis/vc/v1/room_levels/:room_level_id"
        patch_room_level_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_room_level_request: PatchRoomLevelRequest = patch_room_level_request

    def room_level_id(self, room_level_id: str) -> "PatchRoomLevelRequestBuilder":
        self._patch_room_level_request.room_level_id = room_level_id
        self._patch_room_level_request.paths["room_level_id"] = str(room_level_id)
        return self

    def request_body(self, request_body: RoomLevel) -> "PatchRoomLevelRequestBuilder":
        self._patch_room_level_request.request_body = request_body
        self._patch_room_level_request.body = request_body
        return self

    def build(self) -> PatchRoomLevelRequest:
        return self._patch_room_level_request
