# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .room import Room


class PatchRoomRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.room_id: Optional[str] = None
        self.request_body: Optional[Room] = None

    @staticmethod
    def builder() -> "PatchRoomRequestBuilder":
        return PatchRoomRequestBuilder()


class PatchRoomRequestBuilder(object):

    def __init__(self) -> None:
        patch_room_request = PatchRoomRequest()
        patch_room_request.http_method = HttpMethod.PATCH
        patch_room_request.uri = "/open-apis/vc/v1/rooms/:room_id"
        patch_room_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_room_request: PatchRoomRequest = patch_room_request

    def user_id_type(self, user_id_type: str) -> "PatchRoomRequestBuilder":
        self._patch_room_request.user_id_type = user_id_type
        self._patch_room_request.add_query("user_id_type", user_id_type)
        return self

    def room_id(self, room_id: str) -> "PatchRoomRequestBuilder":
        self._patch_room_request.room_id = room_id
        self._patch_room_request.paths["room_id"] = str(room_id)
        return self

    def request_body(self, request_body: Room) -> "PatchRoomRequestBuilder":
        self._patch_room_request.request_body = request_body
        self._patch_room_request.body = request_body
        return self

    def build(self) -> PatchRoomRequest:
        return self._patch_room_request
