# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class QualityNetwork(object):
    _types = {
        "time": str,
        "network_delay": str,
        "bitrate_received": str,
        "packet_loss_avg_received": str,
        "packet_loss_max_received": str,
        "bitrate_sent": str,
        "packet_loss_avg_sent": str,
        "packet_loss_max_sent": str,
    }

    def __init__(self, d=None):
        self.time: Optional[str] = None
        self.network_delay: Optional[str] = None
        self.bitrate_received: Optional[str] = None
        self.packet_loss_avg_received: Optional[str] = None
        self.packet_loss_max_received: Optional[str] = None
        self.bitrate_sent: Optional[str] = None
        self.packet_loss_avg_sent: Optional[str] = None
        self.packet_loss_max_sent: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "QualityNetworkBuilder":
        return QualityNetworkBuilder()


class QualityNetworkBuilder(object):
    def __init__(self) -> None:
        self._quality_network = QualityNetwork()

    def time(self, time: str) -> "QualityNetworkBuilder":
        self._quality_network.time = time
        return self

    def network_delay(self, network_delay: str) -> "QualityNetworkBuilder":
        self._quality_network.network_delay = network_delay
        return self

    def bitrate_received(self, bitrate_received: str) -> "QualityNetworkBuilder":
        self._quality_network.bitrate_received = bitrate_received
        return self

    def packet_loss_avg_received(self, packet_loss_avg_received: str) -> "QualityNetworkBuilder":
        self._quality_network.packet_loss_avg_received = packet_loss_avg_received
        return self

    def packet_loss_max_received(self, packet_loss_max_received: str) -> "QualityNetworkBuilder":
        self._quality_network.packet_loss_max_received = packet_loss_max_received
        return self

    def bitrate_sent(self, bitrate_sent: str) -> "QualityNetworkBuilder":
        self._quality_network.bitrate_sent = bitrate_sent
        return self

    def packet_loss_avg_sent(self, packet_loss_avg_sent: str) -> "QualityNetworkBuilder":
        self._quality_network.packet_loss_avg_sent = packet_loss_avg_sent
        return self

    def packet_loss_max_sent(self, packet_loss_max_sent: str) -> "QualityNetworkBuilder":
        self._quality_network.packet_loss_max_sent = packet_loss_max_sent
        return self

    def build(self) -> "QualityNetwork":
        return self._quality_network
