# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class QueryRoomConfigRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.scope: Optional[int] = None
        self.country_id: Optional[str] = None
        self.district_id: Optional[str] = None
        self.building_id: Optional[str] = None
        self.floor_name: Optional[str] = None
        self.room_id: Optional[str] = None
        self.user_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "QueryRoomConfigRequestBuilder":
        return QueryRoomConfigRequestBuilder()


class QueryRoomConfigRequestBuilder(object):

    def __init__(self) -> None:
        query_room_config_request = QueryRoomConfigRequest()
        query_room_config_request.http_method = HttpMethod.GET
        query_room_config_request.uri = "/open-apis/vc/v1/room_configs/query"
        query_room_config_request.token_types = {AccessTokenType.TENANT}
        self._query_room_config_request: QueryRoomConfigRequest = query_room_config_request

    def scope(self, scope: int) -> "QueryRoomConfigRequestBuilder":
        self._query_room_config_request.scope = scope
        self._query_room_config_request.add_query("scope", scope)
        return self

    def country_id(self, country_id: str) -> "QueryRoomConfigRequestBuilder":
        self._query_room_config_request.country_id = country_id
        self._query_room_config_request.add_query("country_id", country_id)
        return self

    def district_id(self, district_id: str) -> "QueryRoomConfigRequestBuilder":
        self._query_room_config_request.district_id = district_id
        self._query_room_config_request.add_query("district_id", district_id)
        return self

    def building_id(self, building_id: str) -> "QueryRoomConfigRequestBuilder":
        self._query_room_config_request.building_id = building_id
        self._query_room_config_request.add_query("building_id", building_id)
        return self

    def floor_name(self, floor_name: str) -> "QueryRoomConfigRequestBuilder":
        self._query_room_config_request.floor_name = floor_name
        self._query_room_config_request.add_query("floor_name", floor_name)
        return self

    def room_id(self, room_id: str) -> "QueryRoomConfigRequestBuilder":
        self._query_room_config_request.room_id = room_id
        self._query_room_config_request.add_query("room_id", room_id)
        return self

    def user_id_type(self, user_id_type: str) -> "QueryRoomConfigRequestBuilder":
        self._query_room_config_request.user_id_type = user_id_type
        self._query_room_config_request.add_query("user_id_type", user_id_type)
        return self

    def build(self) -> QueryRoomConfigRequest:
        return self._query_room_config_request
