# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .report_meeting_daily import ReportMeetingDaily


class Report(object):
    _types = {
        "total_meeting_count": int,
        "total_meeting_duration": int,
        "total_participant_count": int,
        "daily_report": List[ReportMeetingDaily],
    }

    def __init__(self, d=None):
        self.total_meeting_count: Optional[int] = None
        self.total_meeting_duration: Optional[int] = None
        self.total_participant_count: Optional[int] = None
        self.daily_report: Optional[List[ReportMeetingDaily]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ReportBuilder":
        return ReportBuilder()


class ReportBuilder(object):
    def __init__(self) -> None:
        self._report = Report()

    def total_meeting_count(self, total_meeting_count: int) -> "ReportBuilder":
        self._report.total_meeting_count = total_meeting_count
        return self

    def total_meeting_duration(self, total_meeting_duration: int) -> "ReportBuilder":
        self._report.total_meeting_duration = total_meeting_duration
        return self

    def total_participant_count(self, total_participant_count: int) -> "ReportBuilder":
        self._report.total_participant_count = total_participant_count
        return self

    def daily_report(self, daily_report: List[ReportMeetingDaily]) -> "ReportBuilder":
        self._report.daily_report = daily_report
        return self

    def build(self) -> "Report":
        return self._report
