# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .reserve_permission_checker import ReservePermissionChecker


class ReserveActionPermission(object):
    _types = {
        "permission": int,
        "permission_checkers": List[ReservePermissionChecker],
    }

    def __init__(self, d=None):
        self.permission: Optional[int] = None
        self.permission_checkers: Optional[List[ReservePermissionChecker]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ReserveActionPermissionBuilder":
        return ReserveActionPermissionBuilder()


class ReserveActionPermissionBuilder(object):
    def __init__(self) -> None:
        self._reserve_action_permission = ReserveActionPermission()

    def permission(self, permission: int) -> "ReserveActionPermissionBuilder":
        self._reserve_action_permission.permission = permission
        return self

    def permission_checkers(self,
                            permission_checkers: List[ReservePermissionChecker]) -> "ReserveActionPermissionBuilder":
        self._reserve_action_permission.permission_checkers = permission_checkers
        return self

    def build(self) -> "ReserveActionPermission":
        return self._reserve_action_permission
