# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .subscribe_department import SubscribeDepartment
from .subscribe_user import SubscribeUser


class ReserveAdminConfig(object):
    _types = {
        "depts": List[SubscribeDepartment],
        "users": List[SubscribeUser],
    }

    def __init__(self, d=None):
        self.depts: Optional[List[SubscribeDepartment]] = None
        self.users: Optional[List[SubscribeUser]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ReserveAdminConfigBuilder":
        return ReserveAdminConfigBuilder()


class ReserveAdminConfigBuilder(object):
    def __init__(self) -> None:
        self._reserve_admin_config = ReserveAdminConfig()

    def depts(self, depts: List[SubscribeDepartment]) -> "ReserveAdminConfigBuilder":
        self._reserve_admin_config.depts = depts
        return self

    def users(self, users: List[SubscribeUser]) -> "ReserveAdminConfigBuilder":
        self._reserve_admin_config.users = users
        return self

    def build(self) -> "ReserveAdminConfig":
        return self._reserve_admin_config
