# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .approval_config import ApprovalConfig
from .reserve_scope_config import ReserveScopeConfig
from .time_config import TimeConfig


class ReserveScopeReserveConfigResponseBody(object):
    _types = {
        "approve_config": ApprovalConfig,
        "time_config": TimeConfig,
        "reserve_scope_config": ReserveScopeConfig,
    }

    def __init__(self, d=None):
        self.approve_config: Optional[ApprovalConfig] = None
        self.time_config: Optional[TimeConfig] = None
        self.reserve_scope_config: Optional[ReserveScopeConfig] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ReserveScopeReserveConfigResponseBodyBuilder":
        return ReserveScopeReserveConfigResponseBodyBuilder()


class ReserveScopeReserveConfigResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._reserve_scope_reserve_config_response_body = ReserveScopeReserveConfigResponseBody()

    def approve_config(self, approve_config: ApprovalConfig) -> "ReserveScopeReserveConfigResponseBodyBuilder":
        self._reserve_scope_reserve_config_response_body.approve_config = approve_config
        return self

    def time_config(self, time_config: TimeConfig) -> "ReserveScopeReserveConfigResponseBodyBuilder":
        self._reserve_scope_reserve_config_response_body.time_config = time_config
        return self

    def reserve_scope_config(self,
                             reserve_scope_config: ReserveScopeConfig) -> "ReserveScopeReserveConfigResponseBodyBuilder":
        self._reserve_scope_reserve_config_response_body.reserve_scope_config = reserve_scope_config
        return self

    def build(self) -> "ReserveScopeReserveConfigResponseBody":
        return self._reserve_scope_reserve_config_response_body
