# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class ResourceReservationListExportRequestBody(object):
    _types = {
        "room_level_id": str,
        "need_topic": bool,
        "start_time": int,
        "end_time": int,
        "room_ids": List[str],
        "is_exclude": bool,
    }

    def __init__(self, d=None):
        self.room_level_id: Optional[str] = None
        self.need_topic: Optional[bool] = None
        self.start_time: Optional[int] = None
        self.end_time: Optional[int] = None
        self.room_ids: Optional[List[str]] = None
        self.is_exclude: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ResourceReservationListExportRequestBodyBuilder":
        return ResourceReservationListExportRequestBodyBuilder()


class ResourceReservationListExportRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._resource_reservation_list_export_request_body = ResourceReservationListExportRequestBody()

    def room_level_id(self, room_level_id: str) -> "ResourceReservationListExportRequestBodyBuilder":
        self._resource_reservation_list_export_request_body.room_level_id = room_level_id
        return self

    def need_topic(self, need_topic: bool) -> "ResourceReservationListExportRequestBodyBuilder":
        self._resource_reservation_list_export_request_body.need_topic = need_topic
        return self

    def start_time(self, start_time: int) -> "ResourceReservationListExportRequestBodyBuilder":
        self._resource_reservation_list_export_request_body.start_time = start_time
        return self

    def end_time(self, end_time: int) -> "ResourceReservationListExportRequestBodyBuilder":
        self._resource_reservation_list_export_request_body.end_time = end_time
        return self

    def room_ids(self, room_ids: List[str]) -> "ResourceReservationListExportRequestBodyBuilder":
        self._resource_reservation_list_export_request_body.room_ids = room_ids
        return self

    def is_exclude(self, is_exclude: bool) -> "ResourceReservationListExportRequestBodyBuilder":
        self._resource_reservation_list_export_request_body.is_exclude = is_exclude
        return self

    def build(self) -> "ResourceReservationListExportRequestBody":
        return self._resource_reservation_list_export_request_body
