# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class RoomDigitalSignageMaterial(object):
    _types = {
        "id": str,
        "name": str,
        "material_type": int,
        "url": str,
        "duration": int,
        "cover": str,
        "md5": str,
        "vid": str,
        "size": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.material_type: Optional[int] = None
        self.url: Optional[str] = None
        self.duration: Optional[int] = None
        self.cover: Optional[str] = None
        self.md5: Optional[str] = None
        self.vid: Optional[str] = None
        self.size: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "RoomDigitalSignageMaterialBuilder":
        return RoomDigitalSignageMaterialBuilder()


class RoomDigitalSignageMaterialBuilder(object):
    def __init__(self) -> None:
        self._room_digital_signage_material = RoomDigitalSignageMaterial()

    def id(self, id: str) -> "RoomDigitalSignageMaterialBuilder":
        self._room_digital_signage_material.id = id
        return self

    def name(self, name: str) -> "RoomDigitalSignageMaterialBuilder":
        self._room_digital_signage_material.name = name
        return self

    def material_type(self, material_type: int) -> "RoomDigitalSignageMaterialBuilder":
        self._room_digital_signage_material.material_type = material_type
        return self

    def url(self, url: str) -> "RoomDigitalSignageMaterialBuilder":
        self._room_digital_signage_material.url = url
        return self

    def duration(self, duration: int) -> "RoomDigitalSignageMaterialBuilder":
        self._room_digital_signage_material.duration = duration
        return self

    def cover(self, cover: str) -> "RoomDigitalSignageMaterialBuilder":
        self._room_digital_signage_material.cover = cover
        return self

    def md5(self, md5: str) -> "RoomDigitalSignageMaterialBuilder":
        self._room_digital_signage_material.md5 = md5
        return self

    def vid(self, vid: str) -> "RoomDigitalSignageMaterialBuilder":
        self._room_digital_signage_material.vid = vid
        return self

    def size(self, size: str) -> "RoomDigitalSignageMaterialBuilder":
        self._room_digital_signage_material.size = size
        return self

    def build(self) -> "RoomDigitalSignageMaterial":
        return self._room_digital_signage_material
