# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .device import Device
from .room_status_event import RoomStatusEvent


class RoomEvent(object):
    _types = {
        "room_id": str,
        "name": str,
        "capacity": int,
        "description": str,
        "display_id": str,
        "custom_room_id": str,
        "room_level_id": str,
        "path": List[str],
        "room_status": RoomStatusEvent,
        "device": List[Device],
    }

    def __init__(self, d=None):
        self.room_id: Optional[str] = None
        self.name: Optional[str] = None
        self.capacity: Optional[int] = None
        self.description: Optional[str] = None
        self.display_id: Optional[str] = None
        self.custom_room_id: Optional[str] = None
        self.room_level_id: Optional[str] = None
        self.path: Optional[List[str]] = None
        self.room_status: Optional[RoomStatusEvent] = None
        self.device: Optional[List[Device]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "RoomEventBuilder":
        return RoomEventBuilder()


class RoomEventBuilder(object):
    def __init__(self) -> None:
        self._room_event = RoomEvent()

    def room_id(self, room_id: str) -> "RoomEventBuilder":
        self._room_event.room_id = room_id
        return self

    def name(self, name: str) -> "RoomEventBuilder":
        self._room_event.name = name
        return self

    def capacity(self, capacity: int) -> "RoomEventBuilder":
        self._room_event.capacity = capacity
        return self

    def description(self, description: str) -> "RoomEventBuilder":
        self._room_event.description = description
        return self

    def display_id(self, display_id: str) -> "RoomEventBuilder":
        self._room_event.display_id = display_id
        return self

    def custom_room_id(self, custom_room_id: str) -> "RoomEventBuilder":
        self._room_event.custom_room_id = custom_room_id
        return self

    def room_level_id(self, room_level_id: str) -> "RoomEventBuilder":
        self._room_event.room_level_id = room_level_id
        return self

    def path(self, path: List[str]) -> "RoomEventBuilder":
        self._room_event.path = path
        return self

    def room_status(self, room_status: RoomStatusEvent) -> "RoomEventBuilder":
        self._room_event.room_status = room_status
        return self

    def device(self, device: List[Device]) -> "RoomEventBuilder":
        self._room_event.device = device
        return self

    def build(self) -> "RoomEvent":
        return self._room_event
