# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .search_room_request_body import SearchRoomRequestBody


class SearchRoomRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[SearchRoomRequestBody] = None

    @staticmethod
    def builder() -> "SearchRoomRequestBuilder":
        return SearchRoomRequestBuilder()


class SearchRoomRequestBuilder(object):

    def __init__(self) -> None:
        search_room_request = SearchRoomRequest()
        search_room_request.http_method = HttpMethod.POST
        search_room_request.uri = "/open-apis/vc/v1/rooms/search"
        search_room_request.token_types = {AccessTokenType.USER}
        self._search_room_request: SearchRoomRequest = search_room_request

    def user_id_type(self, user_id_type: str) -> "SearchRoomRequestBuilder":
        self._search_room_request.user_id_type = user_id_type
        self._search_room_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: SearchRoomRequestBody) -> "SearchRoomRequestBuilder":
        self._search_room_request.request_body = request_body
        self._search_room_request.body = request_body
        return self

    def build(self) -> SearchRoomRequest:
        return self._search_room_request
