# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .room import Room


class SearchRoomResponseBody(object):
    _types = {
        "rooms": List[Room],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.rooms: Optional[List[Room]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchRoomResponseBodyBuilder":
        return SearchRoomResponseBodyBuilder()


class SearchRoomResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._search_room_response_body = SearchRoomResponseBody()

    def rooms(self, rooms: List[Room]) -> "SearchRoomResponseBodyBuilder":
        self._search_room_response_body.rooms = rooms
        return self

    def page_token(self, page_token: str) -> "SearchRoomResponseBodyBuilder":
        self._search_room_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "SearchRoomResponseBodyBuilder":
        self._search_room_response_body.has_more = has_more
        return self

    def build(self) -> "SearchRoomResponseBody":
        return self._search_room_response_body
