# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.end_meeting_request import EndMeetingRequest
from ..model.end_meeting_response import EndMeetingResponse
from ..model.get_meeting_request import GetMeetingRequest
from ..model.get_meeting_response import GetMeetingResponse
from ..model.invite_meeting_request import InviteMeetingRequest
from ..model.invite_meeting_response import InviteMeetingResponse
from ..model.kickout_meeting_request import KickoutMeetingRequest
from ..model.kickout_meeting_response import KickoutMeetingResponse
from ..model.list_by_no_meeting_request import ListByNoMeetingRequest
from ..model.list_by_no_meeting_response import ListByNoMeetingResponse
from ..model.set_host_meeting_request import SetHostMeetingRequest
from ..model.set_host_meeting_response import SetHostMeetingResponse


class Meeting(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def end(self, request: EndMeetingRequest, option: Optional[RequestOption] = None) -> EndMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: EndMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), EndMeetingResponse)
        response.raw = resp

        return response

    async def aend(self, request: EndMeetingRequest, option: Optional[RequestOption] = None) -> EndMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: EndMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), EndMeetingResponse)
        response.raw = resp

        return response

    def get(self, request: GetMeetingRequest, option: Optional[RequestOption] = None) -> GetMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), GetMeetingResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetMeetingRequest, option: Optional[RequestOption] = None) -> GetMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), GetMeetingResponse)
        response.raw = resp

        return response

    def invite(self, request: InviteMeetingRequest, option: Optional[RequestOption] = None) -> InviteMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: InviteMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), InviteMeetingResponse)
        response.raw = resp

        return response

    async def ainvite(self, request: InviteMeetingRequest,
                      option: Optional[RequestOption] = None) -> InviteMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: InviteMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), InviteMeetingResponse)
        response.raw = resp

        return response

    def kickout(self, request: KickoutMeetingRequest, option: Optional[RequestOption] = None) -> KickoutMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: KickoutMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), KickoutMeetingResponse)
        response.raw = resp

        return response

    async def akickout(self, request: KickoutMeetingRequest,
                       option: Optional[RequestOption] = None) -> KickoutMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: KickoutMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), KickoutMeetingResponse)
        response.raw = resp

        return response

    def list_by_no(self, request: ListByNoMeetingRequest,
                   option: Optional[RequestOption] = None) -> ListByNoMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListByNoMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), ListByNoMeetingResponse)
        response.raw = resp

        return response

    async def alist_by_no(self, request: ListByNoMeetingRequest,
                          option: Optional[RequestOption] = None) -> ListByNoMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListByNoMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), ListByNoMeetingResponse)
        response.raw = resp

        return response

    def set_host(self, request: SetHostMeetingRequest,
                 option: Optional[RequestOption] = None) -> SetHostMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SetHostMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), SetHostMeetingResponse)
        response.raw = resp

        return response

    async def aset_host(self, request: SetHostMeetingRequest,
                        option: Optional[RequestOption] = None) -> SetHostMeetingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SetHostMeetingResponse = JSON.unmarshal(str(resp.content, UTF_8), SetHostMeetingResponse)
        response.raw = resp

        return response
